/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.table;

import com.alipay.oceanbase.rpc.ObTableClient;
import com.alipay.oceanbase.rpc.checkandmutate.CheckAndInsUp;
import com.alipay.oceanbase.rpc.exception.ExceptionUtil;
import com.alipay.oceanbase.rpc.exception.FeatureNotSupportedException;
import com.alipay.oceanbase.rpc.exception.ObTableException;
import com.alipay.oceanbase.rpc.exception.ObTableReplicaNotReadableException;
import com.alipay.oceanbase.rpc.exception.ObTableRoutingWrongException;
import com.alipay.oceanbase.rpc.exception.ObTableTimeoutExcetion;
import com.alipay.oceanbase.rpc.exception.ObTableUnexpectedException;
import com.alipay.oceanbase.rpc.location.model.ObServerRoute;
import com.alipay.oceanbase.rpc.location.model.partition.ObPair;
import com.alipay.oceanbase.rpc.mutation.Append;
import com.alipay.oceanbase.rpc.mutation.Delete;
import com.alipay.oceanbase.rpc.mutation.Increment;
import com.alipay.oceanbase.rpc.mutation.Insert;
import com.alipay.oceanbase.rpc.mutation.InsertOrUpdate;
import com.alipay.oceanbase.rpc.mutation.Mutation;
import com.alipay.oceanbase.rpc.mutation.Put;
import com.alipay.oceanbase.rpc.mutation.Replace;
import com.alipay.oceanbase.rpc.mutation.Update;
import com.alipay.oceanbase.rpc.mutation.result.MutationResult;
import com.alipay.oceanbase.rpc.protocol.payload.ObPayload;
import com.alipay.oceanbase.rpc.protocol.payload.ResultCodes;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObObj;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObRowKey;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableApiMove;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableBatchOperation;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableEntityType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableLSOpRequest;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableLSOpResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableLSOperation;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableOperationType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableSingleOp;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableSingleOpEntity;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableSingleOpQuery;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableSingleOpResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableTabletOp;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.ObTableTabletOpResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObNewRange;
import com.alipay.oceanbase.rpc.table.AbstractTableBatchOps;
import com.alipay.oceanbase.rpc.table.ConcurrentTask;
import com.alipay.oceanbase.rpc.table.ConcurrentTaskExecutor;
import com.alipay.oceanbase.rpc.table.ObTable;
import com.alipay.oceanbase.rpc.table.ObTableClientBatchOpsImpl;
import com.alipay.oceanbase.rpc.table.ObTableParam;
import com.alipay.oceanbase.rpc.table.api.TableQuery;
import com.alipay.oceanbase.rpc.threadlocal.ThreadLocalMap;
import com.alipay.oceanbase.rpc.util.MonitorUtil;
import com.alipay.oceanbase.rpc.util.TableClientLoggerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class ObTableClientLSBatchOpsImpl
extends AbstractTableBatchOps {
    private static final Logger logger = TableClientLoggerFactory.getLogger(ObTableClientBatchOpsImpl.class);
    private final ObTableClient obTableClient;
    private ExecutorService executorService;
    private boolean returningAffectedEntity = false;
    private boolean needAllProp = false;
    private List<ObTableSingleOp> batchOperation;

    public ObTableClientLSBatchOpsImpl(String tableName, ObTableClient obTableClient) {
        this.tableName = tableName;
        this.obTableClient = obTableClient;
        this.executorService = obTableClient.getRuntimeBatchExecutor();
        this.batchOperation = new ArrayList<ObTableSingleOp>();
    }

    @Override
    public ObTableBatchOperation getObTableBatchOperation() {
        return null;
    }

    public List<ObTableSingleOp> getSingleOperations() {
        return this.batchOperation;
    }

    @Override
    public void get(Object[] rowkeys, String[] columns) {
        throw new FeatureNotSupportedException();
    }

    @Override
    public void update(Object[] rowkeys, String[] columns, Object[] values) {
        throw new FeatureNotSupportedException();
    }

    @Override
    public void delete(Object[] rowkeys) {
        throw new FeatureNotSupportedException();
    }

    @Override
    public void insert(Object[] rowkeys, String[] columns, Object[] values) {
        throw new FeatureNotSupportedException();
    }

    @Override
    public void replace(Object[] rowkeys, String[] columns, Object[] values) {
        throw new FeatureNotSupportedException();
    }

    @Override
    public void insertOrUpdate(Object[] rowkeys, String[] columns, Object[] values) {
        throw new FeatureNotSupportedException();
    }

    @Override
    public void increment(Object[] rowkeys, String[] columns, Object[] values, boolean withResult) {
        throw new FeatureNotSupportedException();
    }

    @Override
    public void append(Object[] rowkeys, String[] columns, Object[] values, boolean withResult) {
        throw new FeatureNotSupportedException();
    }

    @Override
    public void put(Object[] rowkeys, String[] columns, Object[] values) {
        throw new FeatureNotSupportedException();
    }

    private void addOperation(ObTableSingleOp singleOp) {
        this.batchOperation.add(singleOp);
    }

    public void addOperation(CheckAndInsUp checkAndInsUp) {
        InsertOrUpdate insUp = checkAndInsUp.getInsUp();
        ObTableSingleOpQuery query = new ObTableSingleOpQuery();
        ObNewRange range = new ObNewRange();
        range.setStartKey(ObRowKey.getInstance(insUp.getRowKeyValues()));
        range.setEndKey(ObRowKey.getInstance(insUp.getRowKeyValues()));
        query.addScanRangeColumns(insUp.getRowKeyNames());
        query.addScanRange(range);
        query.setFilterString(checkAndInsUp.getFilter().toString());
        String[] rowKeyNames = checkAndInsUp.getInsUp().getRowKeyNames().toArray(new String[0]);
        Object[] rowKeyValues = checkAndInsUp.getInsUp().getRowKeyValues().toArray(new Object[0]);
        String[] propertiesNames = checkAndInsUp.getInsUp().getColumns();
        Object[] propertiesValues = checkAndInsUp.getInsUp().getValues();
        ObTableSingleOpEntity entity = ObTableSingleOpEntity.getInstance(rowKeyNames, rowKeyValues, propertiesNames, propertiesValues);
        ObTableSingleOp singleOp = new ObTableSingleOp();
        singleOp.setSingleOpType(ObTableOperationType.CHECK_AND_INSERT_UP);
        singleOp.setIsCheckNoExists(!checkAndInsUp.isCheckExists());
        singleOp.setQuery(query);
        singleOp.addEntity(entity);
        this.addOperation(singleOp);
    }

    public void addOperation(TableQuery query) throws Exception {
        String[] rowKeyNames = query.getRowKey().getColumns();
        if (rowKeyNames == null || rowKeyNames.length == 0) {
            throw new IllegalArgumentException("rowKey is empty in get op");
        }
        Object[] rowKey = query.getRowKey().getValues();
        String[] propertiesNames = query.getSelectColumns().toArray(new String[0]);
        ObTableSingleOpEntity entity = ObTableSingleOpEntity.getInstance(rowKeyNames, rowKey, propertiesNames, null);
        if (propertiesNames.length == 0) {
            this.needAllProp = true;
        }
        ObTableSingleOp singleOp = new ObTableSingleOp();
        singleOp.setSingleOpType(ObTableOperationType.GET);
        singleOp.addEntity(entity);
        this.addOperation(singleOp);
    }

    public void addOperation(Mutation mutation) throws Exception {
        String[] rowKeyNames = null;
        Object[] rowKeyValues = null;
        String[] propertiesNames = null;
        Object[] propertiesValues = null;
        ObTableOperationType type = mutation.getOperationType();
        switch (type) {
            case GET: {
                throw new IllegalArgumentException("Invalid type in batch operation, " + (Object)((Object)type));
            }
            case INSERT: {
                ((Insert)mutation).removeRowkeyFromMutateColval();
                rowKeyNames = ((Insert)mutation).getRowKeyNames().toArray(new String[0]);
                rowKeyValues = ((Insert)mutation).getRowKeyValues().toArray(new Object[0]);
                propertiesNames = ((Insert)mutation).getColumns();
                propertiesValues = ((Insert)mutation).getValues();
                break;
            }
            case DEL: {
                rowKeyNames = ((Delete)mutation).getRowKeyNames().toArray(new String[0]);
                rowKeyValues = ((Delete)mutation).getRowKeyValues().toArray(new Object[0]);
                break;
            }
            case UPDATE: {
                ((Update)mutation).removeRowkeyFromMutateColval();
                rowKeyNames = ((Update)mutation).getRowKeyNames().toArray(new String[0]);
                rowKeyValues = ((Update)mutation).getRowKeyValues().toArray(new Object[0]);
                propertiesNames = ((Update)mutation).getColumns();
                propertiesValues = ((Update)mutation).getValues();
                break;
            }
            case INSERT_OR_UPDATE: {
                ((InsertOrUpdate)mutation).removeRowkeyFromMutateColval();
                rowKeyNames = ((InsertOrUpdate)mutation).getRowKeyNames().toArray(new String[0]);
                rowKeyValues = ((InsertOrUpdate)mutation).getRowKeyValues().toArray(new Object[0]);
                propertiesNames = ((InsertOrUpdate)mutation).getColumns();
                propertiesValues = ((InsertOrUpdate)mutation).getValues();
                break;
            }
            case REPLACE: {
                ((Replace)mutation).removeRowkeyFromMutateColval();
                rowKeyNames = ((Replace)mutation).getRowKeyNames().toArray(new String[0]);
                rowKeyValues = ((Replace)mutation).getRowKeyValues().toArray(new Object[0]);
                propertiesNames = ((Replace)mutation).getColumns();
                propertiesValues = ((Replace)mutation).getValues();
                break;
            }
            case INCREMENT: {
                ((Increment)mutation).removeRowkeyFromMutateColval();
                rowKeyNames = ((Increment)mutation).getRowKeyNames().toArray(new String[0]);
                rowKeyValues = ((Increment)mutation).getRowKeyValues().toArray(new Object[0]);
                propertiesNames = ((Increment)mutation).getColumns();
                propertiesValues = ((Increment)mutation).getValues();
                break;
            }
            case APPEND: {
                ((Append)mutation).removeRowkeyFromMutateColval();
                rowKeyNames = ((Append)mutation).getRowKeyNames().toArray(new String[0]);
                rowKeyValues = ((Append)mutation).getRowKeyValues().toArray(new Object[0]);
                propertiesNames = ((Append)mutation).getColumns();
                propertiesValues = ((Append)mutation).getValues();
                break;
            }
            case PUT: {
                ((Put)mutation).removeRowkeyFromMutateColval();
                rowKeyNames = ((Put)mutation).getRowKeyNames().toArray(new String[0]);
                rowKeyValues = ((Put)mutation).getRowKeyValues().toArray(new Object[0]);
                propertiesNames = ((Put)mutation).getColumns();
                propertiesValues = ((Put)mutation).getValues();
                break;
            }
            default: {
                throw new ObTableException("unknown operation type " + (Object)((Object)type));
            }
        }
        ObTableSingleOpEntity entity = ObTableSingleOpEntity.getInstance(rowKeyNames, rowKeyValues, propertiesNames, propertiesValues);
        ObTableSingleOp singleOp = new ObTableSingleOp();
        singleOp.setSingleOpType(type);
        singleOp.addEntity(entity);
        this.addOperation(singleOp);
    }

    @Override
    public List<Object> execute() throws Exception {
        ArrayList<Object> results = new ArrayList<Object>(this.batchOperation.size());
        for (ObTableSingleOpResult result : this.executeInternal()) {
            int errCode = result.getHeader().getErrno();
            if (errCode == ResultCodes.OB_SUCCESS.errorCode) {
                results.add(result.getAffectedRows());
                continue;
            }
            results.add(ExceptionUtil.convertToObTableException(result.getExecuteHost(), result.getExecutePort(), result.getSequence(), result.getUniqueId(), errCode, result.getHeader().getErrMsg()));
        }
        return results;
    }

    @Override
    public List<Object> executeWithResult() throws Exception {
        ArrayList<Object> results = new ArrayList<Object>(this.batchOperation.size());
        for (ObTableSingleOpResult result : this.executeInternal()) {
            int errCode = result.getHeader().getErrno();
            if (errCode == ResultCodes.OB_SUCCESS.errorCode) {
                results.add(new MutationResult(result));
                continue;
            }
            results.add(ExceptionUtil.convertToObTableException(result.getExecuteHost(), result.getExecutePort(), result.getSequence(), result.getUniqueId(), errCode, result.getHeader().getErrMsg()));
        }
        return results;
    }

    public Map<Long, Map<Long, ObPair<ObTableParam, List<ObPair<Integer, ObTableSingleOp>>>>> partitionPrepare() throws Exception {
        List<ObTableSingleOp> operations = this.getSingleOperations();
        HashMap<Long, Map<Long, ObPair<ObTableParam, List<ObPair<Integer, ObTableSingleOp>>>>> lsOperationsMap = new HashMap<Long, Map<Long, ObPair<ObTableParam, List<ObPair<Integer, ObTableSingleOp>>>>>();
        if (this.obTableClient.isOdpMode()) {
            HashMap tabletOperationsMap = new HashMap();
            ObPair obTableOperations = new ObPair(new ObTableParam(this.obTableClient.getOdpTable()), new ArrayList());
            for (int i = 0; i < operations.size(); ++i) {
                ObTableSingleOp operation = operations.get(i);
                ((List)obTableOperations.getRight()).add(new ObPair<Integer, ObTableSingleOp>(i, operation));
            }
            tabletOperationsMap.put(0L, obTableOperations);
            lsOperationsMap.put(-1L, tabletOperationsMap);
            return lsOperationsMap;
        }
        for (int i = 0; i < operations.size(); ++i) {
            ObPair singleOperations;
            ObPair<Long, ObTableParam> tableObPair;
            long lsId;
            HashMap tabletOperations;
            ObTableSingleOp operation = operations.get(i);
            List<ObObj> rowkeyObjs = operation.getRowkeyObjs();
            int rowKeySize = rowkeyObjs.size();
            Object[] rowKey = new Object[rowKeySize];
            for (int j = 0; j < rowKeySize; ++j) {
                rowKey[j] = rowkeyObjs.get(j).getValue();
            }
            String real_tableName = this.tableName;
            if (this.entityType == ObTableEntityType.HKV && this.obTableClient.isTableGroupName(this.tableName)) {
                real_tableName = this.obTableClient.tryGetTableNameFromTableGroupCache(this.tableName, false);
            }
            if ((tabletOperations = (HashMap)lsOperationsMap.get(lsId = (tableObPair = this.obTableClient.getTable(real_tableName, rowKey, false, false, this.obTableClient.getRoute(false))).getRight().getLsId())) == null) {
                tabletOperations = new HashMap();
                lsOperationsMap.put(lsId, tabletOperations);
            }
            if ((singleOperations = (ObPair)tabletOperations.get(tableObPair.getLeft())) == null) {
                singleOperations = new ObPair(tableObPair.getRight(), new ArrayList());
                tabletOperations.put(tableObPair.getLeft(), singleOperations);
            }
            ((List)singleOperations.getRight()).add(new ObPair<Integer, ObTableSingleOp>(i, operation));
        }
        return lsOperationsMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void partitionExecute(ObTableSingleOpResult[] results, Map.Entry<Long, Map<Long, ObPair<ObTableParam, List<ObPair<Integer, ObTableSingleOp>>>>> lsOperation) throws Exception {
        ObTableLSOpResult subLSOpResult;
        long lsId = lsOperation.getKey();
        Map<Long, ObPair<ObTableParam, List<ObPair<Integer, ObTableSingleOp>>>> tabletOperationsMap = lsOperation.getValue();
        if (tabletOperationsMap.size() == 0) {
            logger.warn("the size of tablet operations in ls operation is zero");
            throw new ObTableUnexpectedException("the size of tablet operations in ls operation is zero");
        }
        ObTableLSOpRequest tableLsOpRequest = new ObTableLSOpRequest();
        ObTableLSOperation tableLsOp = new ObTableLSOperation();
        tableLsOp.setLsId(lsId);
        tableLsOp.setReturnOneResult(this.returnOneResult);
        tableLsOp.setNeedAllProp(this.needAllProp);
        tableLsOp.setTableName(this.tableName);
        long tableId = 0L;
        long originPartId = 0L;
        long operationTimeout = 0L;
        ObTable subObTable = null;
        boolean isFirstEntry = true;
        ArrayList<List<ObPair<Integer, ObTableSingleOp>>> lsOperationWithIndexList = new ArrayList<List<ObPair<Integer, ObTableSingleOp>>>();
        for (Map.Entry<Long, ObPair<ObTableParam, List<ObPair<Integer, ObTableSingleOp>>>> tabletOperation : tabletOperationsMap.entrySet()) {
            ObTableParam tableParam = tabletOperation.getValue().getLeft();
            long tabletId = tableParam.getPartitionId();
            List<ObPair<Integer, ObTableSingleOp>> tabletOperationWithIndexList = tabletOperation.getValue().getRight();
            lsOperationWithIndexList.add(tabletOperationWithIndexList);
            ArrayList<ObTableSingleOp> singleOps = new ArrayList<ObTableSingleOp>();
            for (ObPair<Integer, ObTableSingleOp> operationWithIndex : tabletOperationWithIndexList) {
                singleOps.add(operationWithIndex.getRight());
            }
            ObTableTabletOp tableTabletOp = new ObTableTabletOp();
            tableTabletOp.setSingleOperations(singleOps);
            tableTabletOp.setTabletId(tabletId);
            tableLsOp.addTabletOperation(tableTabletOp);
            if (!isFirstEntry) continue;
            tableId = tableParam.getTableId();
            originPartId = tableParam.getPartId();
            operationTimeout = tableParam.getObTable().getObTableOperationTimeout();
            subObTable = tableParam.getObTable();
            isFirstEntry = false;
        }
        tableLsOp.prepare();
        tableLsOpRequest.setLsOperation(tableLsOp);
        tableLsOpRequest.setTableId(tableId);
        tableLsOpRequest.setEntityType(this.entityType);
        tableLsOpRequest.setTimeout(operationTimeout);
        boolean needRefreshTableEntry = false;
        int tryTimes = 0;
        long startExecute = System.currentTimeMillis();
        HashSet<String> failedServerList = null;
        ObServerRoute route = null;
        while (true) {
            this.obTableClient.checkStatus();
            long currentExecute = System.currentTimeMillis();
            long costMillis = currentExecute - startExecute;
            if (costMillis > this.obTableClient.getRuntimeMaxWait()) {
                logger.error("table name: {} ls id:{} it has tried " + tryTimes + " times and it has waited " + costMillis + " ms which exceeds runtime max wait timeout " + this.obTableClient.getRuntimeMaxWait() + " ms", (Object)this.tableName, (Object)lsId);
                throw new ObTableTimeoutExcetion("it has tried " + tryTimes + " times and it has waited " + costMillis + "ms which exceeds runtime max wait timeout " + this.obTableClient.getRuntimeMaxWait() + "ms");
            }
            ++tryTimes;
            try {
                if (this.obTableClient.isOdpMode()) {
                    subObTable = this.obTableClient.getOdpTable();
                } else if (tryTimes > 1) {
                    if (route == null) {
                        route = this.obTableClient.getRoute(false);
                    }
                    if (failedServerList != null) {
                        route.setBlackList(failedServerList);
                    }
                    subObTable = this.obTableClient.getTableWithPartId(this.tableName, originPartId, needRefreshTableEntry, this.obTableClient.isTableEntryRefreshIntervalWait(), false, route).getRight().getObTable();
                }
                ObPayload result = subObTable.execute(tableLsOpRequest);
                if (result != null && result.getPcode() == 4388) {
                    ObTableApiMove moveResponse = (ObTableApiMove)result;
                    this.obTableClient.getRouteTableRefresher().addTableIfAbsent(this.tableName, true);
                    this.obTableClient.getRouteTableRefresher().triggerRefreshTable();
                    subObTable = this.obTableClient.getTable(moveResponse);
                    result = subObTable.execute(tableLsOpRequest);
                    if (result instanceof ObTableApiMove) {
                        ObTableApiMove move = (ObTableApiMove)result;
                        logger.warn("The server has not yet completed the master switch, and returned an incorrect leader with an IP address of {}. Rerouting return IP is {}", (Object)moveResponse.getReplica().getServer().ipToString(), (Object)move.getReplica().getServer().ipToString());
                        throw new ObTableRoutingWrongException();
                    }
                }
                subLSOpResult = (ObTableLSOpResult)result;
                this.obTableClient.resetExecuteContinuousFailureCount(this.tableName);
            }
            catch (Exception ex) {
                block34: {
                    if (this.obTableClient.isOdpMode()) {
                        logger.warn("meet exception when execute ls batch in odp mode.tablename: {}, errMsg: {}", (Object)this.tableName, (Object)ex.getMessage());
                        throw ex;
                    }
                    if (ex instanceof ObTableReplicaNotReadableException) {
                        if (tryTimes - 1 >= this.obTableClient.getRuntimeRetryTimes()) {
                            logger.warn("exhaust retry when replica not readable: {}", (Object)ex.getMessage());
                            throw ex;
                        }
                        logger.warn("tablename:{} ls id:{} retry when replica not readable: {}", new Object[]{this.tableName, lsId, ex.getMessage()});
                        if (failedServerList == null) {
                            failedServerList = new HashSet<String>();
                        }
                        failedServerList.add(subObTable.getIp());
                    } else {
                        if (ex instanceof ObTableException && ((ObTableException)ex).isNeedRefreshTableEntry()) {
                            needRefreshTableEntry = true;
                            logger.warn("tablename:{} ls id:{} batch ops refresh table while meet ObTableMasterChangeException, errorCode: {}", new Object[]{this.tableName, lsId, ((ObTableException)ex).getErrorCode(), ex});
                            if (this.obTableClient.isRetryOnChangeMasterTimes() && tryTimes - 1 < this.obTableClient.getRuntimeRetryTimes()) {
                                logger.warn("tablename:{} ls id:{} batch ops retry while meet ObTableMasterChangeException, errorCode: {} , retry times {}", new Object[]{this.tableName, lsId, ((ObTableException)ex).getErrorCode(), tryTimes, ex});
                                break block34;
                            } else {
                                this.obTableClient.calculateContinuousFailure(this.tableName, ex.getMessage());
                                throw ex;
                            }
                        }
                        this.obTableClient.calculateContinuousFailure(this.tableName, ex.getMessage());
                        throw ex;
                    }
                }
                Thread.sleep(this.obTableClient.getRuntimeRetryInterval());
                continue;
            }
            break;
        }
        long endExecute = System.currentTimeMillis();
        if (subLSOpResult == null) {
            TableClientLoggerFactory.RUNTIME.error("tablename:{} ls id:{} check batch operation result error: client get unexpected NULL result", (Object)this.tableName, (Object)lsId);
            throw new ObTableUnexpectedException("check batch operation result error: client get unexpected NULL result");
        }
        List<ObTableTabletOpResult> tabletOpResults = subLSOpResult.getResults();
        int affectedRows = 0;
        if (this.returnOneResult) {
            ObTableSingleOpResult singleOpResult;
            if (results[0] == null) {
                results[0] = new ObTableSingleOpResult();
            }
            if ((singleOpResult = tabletOpResults.get(0).getResults().get(0)).getHeader().getErrno() != ResultCodes.OB_SUCCESS.errorCode) {
                results[0].getHeader().setErrno(singleOpResult.getHeader().getErrno());
                results[0].getHeader().setMsg(singleOpResult.getHeader().getMsg());
            }
            results[0].setAffectedRows(results[0].getAffectedRows() + tabletOpResults.get(0).getResults().get(0).getAffectedRows());
        } else {
            for (int i = 0; i < tabletOpResults.size(); ++i) {
                List<ObTableSingleOpResult> singleOpResults = tabletOpResults.get(i).getResults();
                for (int j = 0; j < singleOpResults.size(); affectedRows += singleOpResults.size(), ++j) {
                }
                List singleOperationsWithIndexList = (List)lsOperationWithIndexList.get(i);
                if (singleOpResults.size() < singleOperationsWithIndexList.size()) {
                    if (singleOpResults.size() == 1 && this.entityType == ObTableEntityType.HKV) {
                        ObTableSingleOpResult subObTableSingleOpResult = singleOpResults.get(0);
                        subObTableSingleOpResult.setExecuteHost(subObTable.getIp());
                        subObTableSingleOpResult.setExecutePort(subObTable.getPort());
                        for (ObPair SubOperationWithIndexList : singleOperationsWithIndexList) {
                            results[((Integer)SubOperationWithIndexList.getLeft()).intValue()] = subObTableSingleOpResult;
                        }
                        continue;
                    }
                    throw new IllegalArgumentException("check batch operation result size error: operation size [" + singleOperationsWithIndexList.size() + "] result size [" + singleOpResults.size() + "]");
                }
                if (singleOpResults.size() != singleOperationsWithIndexList.size()) {
                    throw new ObTableUnexpectedException("check batch result error: ls " + lsId + " expect result size " + singleOperationsWithIndexList.size() + " actual result size " + singleOpResults.size() + " for " + i + "th tablet operation");
                }
                for (int j = 0; j < singleOperationsWithIndexList.size(); ++j) {
                    ObTableSingleOpResult subObTableSingleOpResult = singleOpResults.get(j);
                    subObTableSingleOpResult.setExecuteHost(subObTable.getIp());
                    subObTableSingleOpResult.setExecutePort(subObTable.getPort());
                    results[((Integer)((ObPair)singleOperationsWithIndexList.get((int)j)).getLeft()).intValue()] = subObTableSingleOpResult;
                }
            }
        }
        String endpoint = subObTable.getIp() + ":" + subObTable.getPort();
        MonitorUtil.info((ObPayload)tableLsOpRequest, subObTable.getDatabase(), this.tableName, "LS_BATCH-Execute-", endpoint, tableLsOp, affectedRows, endExecute - startExecute, this.obTableClient.getslowQueryMonitorThreshold());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObTableSingleOpResult[] executeInternal() throws Exception {
        if (this.tableName == null || this.tableName.isEmpty()) {
            throw new IllegalArgumentException("table name is null");
        }
        long start = System.currentTimeMillis();
        ObTableSingleOpResult[] obTableOperationResults = null;
        obTableOperationResults = this.returnOneResult ? new ObTableSingleOpResult[1] : new ObTableSingleOpResult[this.batchOperation.size()];
        Map<Long, Map<Long, ObPair<ObTableParam, List<ObPair<Integer, ObTableSingleOp>>>>> lsOperations = this.partitionPrepare();
        long getTableTime = System.currentTimeMillis();
        final Map<Object, Object> context = ThreadLocalMap.getContextMap();
        if (this.executorService != null && !this.executorService.isShutdown() && lsOperations.size() > 1) {
            final ConcurrentTaskExecutor executor = new ConcurrentTaskExecutor(this.executorService, lsOperations.size());
            for (final Map.Entry<Long, Map<Long, ObPair<ObTableParam, List<ObPair<Integer, ObTableSingleOp>>>>> entry : lsOperations.entrySet()) {
                final ObTableSingleOpResult[] finalObTableOperationResults = obTableOperationResults;
                executor.execute(new ConcurrentTask(){

                    @Override
                    public void doTask() {
                        try {
                            ThreadLocalMap.transmitContextMap(context);
                            ObTableClientLSBatchOpsImpl.this.partitionExecute(finalObTableOperationResults, entry);
                        }
                        catch (Exception e) {
                            logger.error(TableClientLoggerFactory.LCD.convert("01-00026"), (Throwable)e);
                            executor.collectExceptions(e);
                        }
                        finally {
                            ThreadLocalMap.reset();
                        }
                    }
                });
            }
            long timeoutTs = this.obTableClient.getRuntimeBatchMaxWait() * 1000L * 1000L + System.nanoTime();
            try {
                while (timeoutTs > System.nanoTime()) {
                    try {
                        executor.waitComplete(1L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        throw new ObTableUnexpectedException("Batch Concurrent Execute interrupted", e);
                    }
                    if (executor.getThrowableList().size() > 0) {
                        throw new ObTableUnexpectedException("Batch Concurrent Execute Error", executor.getThrowableList().get(0));
                    }
                    if (!executor.isComplete()) continue;
                    break;
                }
            }
            finally {
                executor.stop();
            }
            if (executor.getThrowableList().size() > 0) {
                throw new ObTableUnexpectedException("Batch Concurrent Execute Error", executor.getThrowableList().get(0));
            }
            if (!executor.isComplete()) {
                throw new ObTableUnexpectedException("Batch Concurrent Execute Error, runtimeBatchMaxWait: " + this.obTableClient.getRuntimeBatchMaxWait() + "ms");
            }
        } else {
            for (Map.Entry<Long, Map<Long, ObPair<ObTableParam, List<ObPair<Integer, ObTableSingleOp>>>>> entry : lsOperations.entrySet()) {
                this.partitionExecute(obTableOperationResults, entry);
            }
        }
        if (obTableOperationResults.length <= 0) {
            throw new ObTableUnexpectedException("Ls batch execute returns zero single operation results");
        }
        MonitorUtil.info((ObPayload)obTableOperationResults[0], this.obTableClient.getDatabase(), this.tableName, "LS_BATCH", "", obTableOperationResults.length, getTableTime - start, System.currentTimeMillis() - getTableTime, this.obTableClient.getslowQueryMonitorThreshold());
        return obTableOperationResults;
    }

    @Override
    public void clear() {
        this.batchOperation = new ArrayList<ObTableSingleOp>();
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public boolean isReturningAffectedEntity() {
        return this.returningAffectedEntity;
    }

    public void setReturningAffectedEntity(boolean returningAffectedEntity) {
        this.returningAffectedEntity = returningAffectedEntity;
    }
}

