/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.table;

import com.alipay.oceanbase.rpc.ObTableClient;
import com.alipay.oceanbase.rpc.exception.ObTableException;
import com.alipay.oceanbase.rpc.location.model.partition.ObPair;
import com.alipay.oceanbase.rpc.mutation.Row;
import com.alipay.oceanbase.rpc.protocol.payload.ObPayload;
import com.alipay.oceanbase.rpc.protocol.payload.ResultCodes;
import com.alipay.oceanbase.rpc.protocol.payload.impl.ObRowKey;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.aggregation.ObTableAggregationType;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.AbstractQueryStreamResult;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObBorderFlag;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObNewRange;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObScanOrder;
import com.alipay.oceanbase.rpc.protocol.payload.impl.execute.query.ObTableQuery;
import com.alipay.oceanbase.rpc.stream.ObTableClientQueryAsyncStreamResult;
import com.alipay.oceanbase.rpc.stream.ObTableClientQueryStreamResult;
import com.alipay.oceanbase.rpc.stream.QueryResultSet;
import com.alipay.oceanbase.rpc.table.AbstractTableQueryImpl;
import com.alipay.oceanbase.rpc.table.ObTableParam;
import com.alipay.oceanbase.rpc.table.api.TableQuery;
import com.alipay.oceanbase.rpc.util.MonitorUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ObTableClientQueryImpl
extends AbstractTableQueryImpl {
    private String tableName;
    private final ObTableClient obTableClient;
    private Map<Long, ObPair<Long, ObTableParam>> partitionObTables;
    private Row rowKey;

    public void addAggregation(ObTableAggregationType aggType, String aggColumn) {
        this.tableQuery.addAggregation(aggType, aggColumn);
    }

    public ObTableClientQueryImpl() {
        this.tableName = null;
        this.indexTableName = null;
        this.obTableClient = null;
        this.tableQuery = new ObTableQuery();
        this.rowKey = null;
    }

    public ObTableClientQueryImpl(String tableName, ObTableClient client) {
        this.tableName = tableName;
        this.indexTableName = tableName;
        this.obTableClient = client;
        this.tableQuery = new ObTableQuery();
        this.rowKey = null;
    }

    public ObTableClientQueryImpl(String tableName, ObTableQuery tableQuery, ObTableClient client) {
        this.tableName = tableName;
        this.indexTableName = tableName;
        this.obTableClient = client;
        this.tableQuery = tableQuery;
        this.rowKey = null;
    }

    @Override
    public QueryResultSet execute() throws Exception {
        return new QueryResultSet(this.executeInternal());
    }

    @Override
    public QueryResultSet asyncExecute() throws Exception {
        return new QueryResultSet(this.asyncExecuteInternal());
    }

    @Override
    public TableQuery setKeys(String ... keys) {
        throw new IllegalArgumentException("Not needed");
    }

    @Override
    public TableQuery setRowKey(Row rowKey) throws Exception {
        this.rowKey = rowKey;
        return this;
    }

    public void checkArgumentBeforeExec() throws Exception {
        if (null == this.obTableClient) {
            throw new ObTableException("table client is null");
        }
        if (this.tableQuery.getLimit() < 0 && this.tableQuery.getOffset() > 0) {
            throw new ObTableException("offset can not be use without limit");
        }
        if (this.tableName == null || this.tableName.isEmpty()) {
            throw new IllegalArgumentException("table name is null");
        }
    }

    private void setCommonParams2Result(AbstractQueryStreamResult result) throws Exception {
        result.setTableQuery(this.tableQuery);
        result.setEntityType(this.entityType);
        result.setTableName(this.tableName);
        result.setIndexTableName(this.indexTableName);
        result.setExpectant(this.partitionObTables);
        result.setOperationTimeout(this.operationTimeout);
        result.setReadConsistency(this.obTableClient.getReadConsistency());
    }

    private AbstractQueryStreamResult commonExecute(InitQueryResultCallback<AbstractQueryStreamResult> callable) throws Exception {
        this.checkArgumentBeforeExec();
        long startTime = System.currentTimeMillis();
        this.partitionObTables = new LinkedHashMap<Long, ObPair<Long, ObTableParam>>();
        if (this.tableQuery.getKeyRanges().isEmpty()) {
            this.tableQuery.addKeyRange(ObNewRange.getWholeRange());
        }
        if (this.obTableClient.isOdpMode()) {
            if (this.tableQuery.getScanRangeColumns().isEmpty() && this.tableQuery.getIndexName() != null && !this.tableQuery.getIndexName().equalsIgnoreCase("primary")) {
                throw new ObTableException("key range columns must be specified when use index");
            }
            this.partitionObTables.put(0L, new ObPair<Long, ObTableParam>(0L, new ObTableParam(this.obTableClient.getOdpTable())));
        } else {
            this.initPartitions();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<Long, ObPair<Long, ObTableParam>> entry : this.partitionObTables.entrySet()) {
            stringBuilder.append("#").append(entry.getValue().getRight().getObTable().getIp()).append(":").append(entry.getValue().getRight().getObTable().getPort());
        }
        String endpoint = stringBuilder.toString();
        long getTableTime = System.currentTimeMillis();
        if (this.tableQuery.isAggregation() && this.partitionObTables.size() > 1) {
            throw new ObTableException("Not supported aggregate of multiple partitions, the partition size is: " + this.partitionObTables.size(), ResultCodes.OB_NOT_SUPPORTED.errorCode);
        }
        if (this.tableQuery.isHbaseQuery() && this.obTableClient.getTableGroupInverted().containsKey(this.tableName) && this.tableName.equalsIgnoreCase(this.obTableClient.getTableGroupCache().get(this.obTableClient.getTableGroupInverted().get(this.tableName)))) {
            this.tableName = this.obTableClient.getTableGroupInverted().get(this.tableName);
        }
        AbstractQueryStreamResult streamResult = callable.execute();
        MonitorUtil.info((ObPayload)streamResult, this.obTableClient.getDatabase(), this.tableName, "QUERY", endpoint, this.tableQuery, streamResult, getTableTime - startTime, System.currentTimeMillis() - getTableTime, this.obTableClient.getslowQueryMonitorThreshold());
        return streamResult;
    }

    public ObTableClientQueryStreamResult executeInternal() throws Exception {
        return (ObTableClientQueryStreamResult)this.commonExecute(new InitQueryResultCallback<AbstractQueryStreamResult>(){

            @Override
            ObTableClientQueryStreamResult execute() throws Exception {
                ObTableClientQueryStreamResult obTableClientQueryStreamResult = new ObTableClientQueryStreamResult();
                ObTableClientQueryImpl.this.setCommonParams2Result(obTableClientQueryStreamResult);
                obTableClientQueryStreamResult.setClient(ObTableClientQueryImpl.this.obTableClient);
                obTableClientQueryStreamResult.init();
                return obTableClientQueryStreamResult;
            }
        });
    }

    public ObTableClientQueryAsyncStreamResult asyncExecuteInternal() throws Exception {
        return (ObTableClientQueryAsyncStreamResult)this.commonExecute(new InitQueryResultCallback<AbstractQueryStreamResult>(){

            @Override
            ObTableClientQueryAsyncStreamResult execute() throws Exception {
                ObTableClientQueryAsyncStreamResult obTableClientQueryAsyncStreamResult = new ObTableClientQueryAsyncStreamResult();
                ObTableClientQueryImpl.this.setCommonParams2Result(obTableClientQueryAsyncStreamResult);
                obTableClientQueryAsyncStreamResult.setClient(ObTableClientQueryImpl.this.obTableClient);
                obTableClientQueryAsyncStreamResult.init();
                return obTableClientQueryAsyncStreamResult;
            }
        });
    }

    public void initPartitions() throws Exception {
        String indexName = this.tableQuery.getIndexName();
        if (!this.obTableClient.isOdpMode()) {
            this.indexTableName = this.obTableClient.getIndexTableName(this.tableName, indexName, this.tableQuery.getScanRangeColumns(), false);
        }
        for (ObNewRange rang : this.tableQuery.getKeyRanges()) {
            int i;
            ObRowKey startKey = rang.getStartKey();
            int startKeySize = startKey.getObjs().size();
            ObRowKey endKey = rang.getEndKey();
            int endKeySize = endKey.getObjs().size();
            Object[] start = new Object[startKeySize];
            Object[] end = new Object[endKeySize];
            for (i = 0; i < startKeySize; ++i) {
                start[i] = startKey.getObj(i).isMinObj() || startKey.getObj(i).isMaxObj() ? startKey.getObj(i) : startKey.getObj(i).getValue();
            }
            for (i = 0; i < endKeySize; ++i) {
                end[i] = endKey.getObj(i).isMinObj() || endKey.getObj(i).isMaxObj() ? endKey.getObj(i) : endKey.getObj(i).getValue();
            }
            ObBorderFlag borderFlag = rang.getBorderFlag();
            List<ObPair<Long, ObTableParam>> pairs = this.obTableClient.getTables(this.indexTableName, this.tableQuery, start, borderFlag.isInclusiveStart(), end, borderFlag.isInclusiveEnd(), false, false);
            if (this.tableQuery.getScanOrder() == ObScanOrder.Reverse) {
                for (int i2 = pairs.size() - 1; i2 >= 0; --i2) {
                    this.partitionObTables.put(pairs.get(i2).getLeft(), pairs.get(i2));
                }
                continue;
            }
            for (ObPair<Long, ObTableParam> pair : pairs) {
                this.partitionObTables.put(pair.getLeft(), pair);
            }
        }
    }

    @Override
    public void clear() {
        this.tableQuery = new ObTableQuery();
    }

    @Override
    public ObTableQuery getObTableQuery() {
        return this.tableQuery;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tabName) {
        this.tableName = tabName;
    }

    @Override
    public Row getRowKey() {
        return this.rowKey;
    }

    private static abstract class InitQueryResultCallback<T> {
        private InitQueryResultCallback() {
        }

        abstract T execute() throws Exception;
    }
}

