/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.util;

import com.alipay.sofa.common.thread.SofaThreadPoolExecutor;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class AsyncExecutor {
    private SofaThreadPoolExecutor executor;
    private AtomicLong completeCount = new AtomicLong(0L);
    private AtomicLong taskCount = new AtomicLong(0L);
    private boolean allTaskAdded;
    private CountDownLatch finished = new CountDownLatch(1);
    private Exception exception = null;

    public AsyncExecutor() {
        this(4, 4, 1024);
    }

    public AsyncExecutor(int corePoolSize, int maxPoolSize, int queueSize) {
        this.executor = new SofaThreadPoolExecutor(corePoolSize, maxPoolSize, 1000L, TimeUnit.SECONDS, new LinkedBlockingQueue(queueSize), "asyncPool", "oceanbase-table-client");
    }

    public void waitComplete() throws Exception {
        this.startMonitor();
        this.allTaskAdded = true;
        this.finished.await();
        if (this.exception != null) {
            throw this.exception;
        }
    }

    public void addTask(final Runnable runnable) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    runnable.run();
                }
                catch (Exception ex) {
                    AsyncExecutor.this.exception = ex;
                    AsyncExecutor.this.finishIt();
                }
                finally {
                    AsyncExecutor.this.completeCount.incrementAndGet();
                }
            }
        });
        this.taskCount.incrementAndGet();
    }

    private void startMonitor() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                block2: while (true) {
                    try {
                        while (true) {
                            if (AsyncExecutor.this.allTaskAdded && AsyncExecutor.this.taskCount.get() == AsyncExecutor.this.completeCount.get()) {
                                AsyncExecutor.this.finishIt();
                                break block2;
                            }
                            Thread.sleep(300L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        }).start();
    }

    private void finishIt() {
        this.completeCount.set(this.taskCount.get());
        this.finished.countDown();
        this.executor.shutdown();
    }
}

