/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.util;

import com.alipay.oceanbase.rpc.exception.ObTableAuthException;
import com.alipay.oceanbase.rpc.util.ObBytesString;
import java.security.MessageDigest;

public class Security {
    private static final byte[] bytes = new byte[]{49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 113, 119, 101, 114, 116, 121, 117, 105, 111, 112, 97, 115, 100, 102, 103, 104, 106, 107, 108, 122, 120, 99, 118, 98, 110, 109, 81, 87, 69, 82, 84, 89, 85, 73, 79, 80, 65, 83, 68, 70, 71, 72, 74, 75, 76, 90, 88, 67, 86, 66, 78, 77};
    private static final long multiplier = 25214903917L;
    private static final long addend = 11L;
    private static final long mask = 0xFFFFFFFFFFFFL;
    private static final long integerMask = 0x1FFFFFFFFL;
    private static final long seedUniquifier = 8682522807148012L;
    private static long seed;

    public static final ObBytesString scramblePassword(String password, ObBytesString scrambleSalt) {
        if (password == null || password.isEmpty()) {
            return new ObBytesString();
        }
        return Security.scramblePassword(password.getBytes(), scrambleSalt.bytes);
    }

    public static final ObBytesString scramblePassword(byte[] password, byte[] seed) {
        if (password == null || password.length == 0) {
            return new ObBytesString();
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] pass1 = md.digest(password);
            md.reset();
            byte[] pass2 = md.digest(pass1);
            md.reset();
            md.update(seed);
            byte[] pass3 = md.digest(pass2);
            for (int i = 0; i < pass3.length; ++i) {
                pass3[i] = (byte)(pass3[i] ^ pass1[i]);
            }
            return new ObBytesString(pass3);
        }
        catch (Throwable e) {
            throw new ObTableAuthException("password scramble failed", e);
        }
    }

    public static final ObBytesString getPasswordScramble(int size) {
        byte[] bb = bytes;
        byte[] ab = new byte[size];
        for (int i = 0; i < size; ++i) {
            ab[i] = Security.randomByte(bb);
        }
        return new ObBytesString(ab);
    }

    private static byte randomByte(byte[] b) {
        int ran = (int)((Security.random() & 0x1FFFFFFFFL) >>> 16);
        return b[ran % b.length];
    }

    private static long random() {
        long oldSeed = seed;
        long nextSeed = 0L;
        while (oldSeed == (nextSeed = oldSeed * 25214903917L + 11L & 0xFFFFFFFFFFFFL)) {
        }
        seed = nextSeed;
        return nextSeed;
    }

    static {
        long s = 8682522807148012L + System.nanoTime();
        seed = s = (s ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
    }
}

