/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oceanbase.rpc.util;

import com.alipay.oceanbase.rpc.util.WrappedLogger;
import com.alipay.sofa.common.code.LogCode2Description;
import com.alipay.sofa.common.log.MultiAppLoggerSpaceManager;
import com.alipay.sofa.common.log.adapter.level.AdapterLevel;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.helpers.NOPLogger;

public class TableClientLoggerFactory {
    public static final String OCEANBASE_TABLE_CLIENT_LOGGER_SPACE = "oceanbase-table-client";
    public static final String OCEANBASE_TABLE_CLIENT_BOOT = "OBKV-BOOT";
    public static final String OCEANBASE_TABLE_CLIENT_MONITOR = "OBKV-MONITOR";
    public static final String OCEANBASE_TABLE_CLIENT_RUNTIME = "OBKV-RUNTIME";
    public static final String OCEANBASE_TABLE_CLIENT_DIRECT = "OBKV-DIRECT";
    public static LogCode2Description LCD = LogCode2Description.create((String)"oceanbase-table-client");
    public static Logger BOOT = NOPLogger.NOP_LOGGER;
    public static Logger MONITOR = NOPLogger.NOP_LOGGER;
    public static Logger RUNTIME = NOPLogger.NOP_LOGGER;
    public static Logger DIRECT = NOPLogger.NOP_LOGGER;

    public static Logger getLogger(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        if (!MultiAppLoggerSpaceManager.isSpaceInitialized((String)OCEANBASE_TABLE_CLIENT_LOGGER_SPACE)) {
            MultiAppLoggerSpaceManager.init((String)OCEANBASE_TABLE_CLIENT_LOGGER_SPACE, null);
        }
        return MultiAppLoggerSpaceManager.getLoggerBySpace((String)name, (String)OCEANBASE_TABLE_CLIENT_LOGGER_SPACE);
    }

    public static Logger getLogger(Class<?> klass) {
        if (klass == null) {
            return null;
        }
        return TableClientLoggerFactory.getLogger(klass.getCanonicalName());
    }

    public static Logger getBootLogger() {
        if (BOOT == NOPLogger.NOP_LOGGER) {
            BOOT = new WrappedLogger(TableClientLoggerFactory.getLogger(OCEANBASE_TABLE_CLIENT_BOOT));
        }
        return BOOT;
    }

    public static Logger getMonitorLogger() {
        if (MONITOR == NOPLogger.NOP_LOGGER) {
            MONITOR = new WrappedLogger(TableClientLoggerFactory.getLogger(OCEANBASE_TABLE_CLIENT_MONITOR));
        }
        return MONITOR;
    }

    public static Logger getRUNTIMELogger() {
        if (RUNTIME == NOPLogger.NOP_LOGGER) {
            RUNTIME = new WrappedLogger(TableClientLoggerFactory.getLogger(OCEANBASE_TABLE_CLIENT_RUNTIME));
        }
        return RUNTIME;
    }

    public static Logger getDIRECTLogger() {
        if (DIRECT == NOPLogger.NOP_LOGGER) {
            DIRECT = new WrappedLogger(TableClientLoggerFactory.getLogger(OCEANBASE_TABLE_CLIENT_DIRECT));
        }
        return DIRECT;
    }

    public static void changeLevel(Map<String, String> levelMap) {
        for (Map.Entry<String, String> entry : levelMap.entrySet()) {
            TableClientLoggerFactory.changeLevel(entry.getKey(), entry.getValue());
        }
    }

    public static void changeLevel(String name, String level) {
        MultiAppLoggerSpaceManager.setLoggerLevel((String)name, (String)OCEANBASE_TABLE_CLIENT_LOGGER_SPACE, (AdapterLevel)AdapterLevel.getAdapterLevel((String)level));
    }

    static {
        BOOT = TableClientLoggerFactory.getBootLogger();
        MONITOR = TableClientLoggerFactory.getMonitorLogger();
        RUNTIME = TableClientLoggerFactory.getRUNTIMELogger();
        DIRECT = TableClientLoggerFactory.getDIRECTLogger();
    }
}

