@ECHO OFF

REM --------------------------------------------------------------------------
REM                          OceanBase Copyright@2020
REM                         https://www.oceanbase.com/
REM ---------------------------------------------------------------------------
REM Set JAVA_HOME or JRE_HOME if not already set, ensure any provided settings
REM are valid and consistent with the selected start-up options and set up the
REM endorsed directory. Author: Eric.Sun
REM ---------------------------------------------------------------------------

REM Make sure prerequisite environment variables are set

SETLOCAL ENABLEEXTENSIONS ENABLEDELAYEDEXPANSION

REM Using pushd popd to set PARENT_PATH to the absolute path
PUSHD %~dp0..\..
SET PARENT_PATH=%CD%
POPD

REM Specified the CLASSPATH from %BASE_PATH%/libs
SET CLASSPATH=.;%PARENT_PATH%\lib\*

REM Otherwise either JRE or JDK are fine
IF NOT "%JRE_HOME%" == "" GOTO GOTO_JRE_HOME
IF NOT "%JAVA_HOME%" == "" GOTO GOT_JAVA_HOME
ECHO Neither the JAVA_HOME nor the JRE_HOME environment variable is defined (Oracle JDK 1.8)
ECHO At least one of these environment variable is needed to run this program
GOTO END

REM Check IF we have a usable JDK
IF "%JAVA_HOME%" == "" GOTO NO_JAVA_HOME
IF NOT EXIST "%JAVA_HOME%\bin\java.exe" GOTO NO_JAVA_HOME
SET "JRE_HOME=%JAVA_HOME%"
GOTO GOTO_JAVA_EXE

:NO_JAVA_HOME
ECHO The JAVA_HOME environment variable is NOT defined correctly as the "%JAVA_HOME%\bin\java.exe" is not found
GOTO END

:GOT_JAVA_HOME
REM No JRE given, use JAVA_HOME as JRE_HOME
SET "JRE_HOME=%JAVA_HOME%"

:GOTO_JRE_HOME
REM Check IF we have a usable JRE
IF NOT EXIST "%JRE_HOME%\bin\java.exe" GOTO NO_JRE_HOME
GOTO GOTO_JAVA_EXE

:NO_JRE_HOME
REM Needed at least a JRE
ECHO The JRE_HOME environment variable is NOT defined correctly as the "%JRE_HOME%\bin\java.exe" is not found
GOTO END

:GOTO_JAVA_EXE
REM Don't override JAVA_EXE IF the user has set it previously
IF NOT "%JAVA_EXE%" == "" GOTO OK_JAVA_EXE
REM Set standard command for invoking Java.
REM Also note the quoting as JRE_HOME may contain spaces.
SET JAVA_EXE="%JRE_HOME%\bin\java.exe"
:OK_JAVA_EXE

REM Get remaining unshifted command line arguments and save them in the arrays
SET CMD_LINE_ARGS=
:SET_ARGS
IF ""%1""=="""" GOTO SET_ARGS_DONE
SET CMD_LINE_ARGS=%CMD_LINE_ARGS% %1
SHIFT
GOTO SET_ARGS
:SET_ARGS_DONE

REM ####################################################################################
REM               This batch snippets is used for setting JAVA OPTS: -Xms, -Xmx and GC
REM                               Support on Windows 7/8/10
REM ####################################################################################

SET VM_OPTS="-Xms4G" "-Xmx4G"
SET GC_OPTS="-XX:+UseConcMarkSweepGC"
SET CI_THREAD_OPTS="-XX:CICompilerCount=4"
SET GC_THREAD_OPTS="-XX:ParallelGCThreads=4"

REM ####################################################################################
REM                               Set GC_OPTS by JAVA VERSION
REM                        Option: -XX:+UseG1GC used for JDK >1.8.0_300
REM                  Option: -XX:+UseConcMarkSweepGC used for JDK <1.8.0_300
REM ####################################################################################

FOR /f tokens^=2-5^ delims^=^" %%j in ('%JAVA_EXE% -version 2^>^&1') do set "JAVA_VERSION=%%j%%k%%l%%m"

@ECHO OFF
FOR /f "tokens=1,2 delims=_" %%a in ("%JAVA_VERSION%") do (
SET "MAJOR_VERSION=%%a"
SET "MINOR_VERSION=%%b"
)
ECHO JAVA_OPTS: "%JAVA_VERSION%" "%MAJOR_VERSION%" "%MINOR_VERSION%" %GC_OPTS% %VM_OPTS%

if "%MAJOR_VERSION%"=="1.8.0" (
     if %MINOR_VERSION% geq 300 (set GC_OPTS="-XX:+UseG1GC")
) else (
    ECHO "Error: JDK %JAVA_VERSION% is unsupported. Please install JDK 1.8.0_3XX"
    CMD /C
)

REM Avoid CPU is overload with more GC threads and TireCompile Threads.
REM ####################################################################################
REM                    Set GC_THREAD_OPTS/CI_THREAD_OPTS by CPU Processors
REM              -XX:CICompilerCount, -XX:ParallelGCThreads = max(8, CPU_THREADS)
REM ####################################################################################
REM SET CPU_THREADS=%NUMBER_OF_PROCESSORS%
REM IF %CPU_THREADS% gtr 8 (
REM     SET CPU_THREADS=8;
REM )
REM SET CI_THREAD_OPTS="-XX:CICompilerCount=%CPU_THREADS%";
REM SET GC_THREAD_OPTS="-XX:ParallelGCThreads=%CPU_THREADS%";
REM
REM IF "%EXPERIMENTAL%" == "1" (
REM     REM ####################################################################################
REM     REM                        (EXPERIMENTAL) Set VM_OPTS by System Memory
REM     REM                         -Xms,-Xmx = min(48G, max(1GB, mem * 0.6))
REM     REM                 Note: `wmic` maybe deprecated by Windows PC/Windows Server
REM     REM ####################################################################################
REM     FOR /f "delims=" %%a in ('wmic os get TotalVisibleMemorySize /value^|find "="') do (set "TOTAL_MEM=%%a")
REM
REM     SET /a ALLOC_MEM=%TOTAL_MEM% * 6 / 10485760
REM     IF %ALLOC_MEM% lss 1 (
REM         ECHO Error: Allocated memory is less than 1GB
REM         CMD /C
REM     ) ELSE (
REM         IF %ALLOC_MEM% gtr 48 (SET ALLOC_MEM=48)
REM         SET VM_OPTS="-Xms%ALLOC_MEM%GB" "-Xmx%ALLOC_MEM%GB"
REM     )
REM
REM     ECHO.
REM     ECHO JAVA_OPTS: "%JAVA_VERSION%" "%MAJOR_VERSION%" "%MINOR_VERSION%" %GC_OPTS% %VM_OPTS%
REM )

SET JAVA_OPTS=%JAVA_OPTS% "-server" %VM_OPTS% "-Xss512K" "-XX:MetaspaceSize=128M" "-XX:MaxMetaspaceSize=128M"
SET JAVA_OPTS=%JAVA_OPTS% %GC_OPTS%  %CI_THREAD_OPTS%  %GC_THREAD_OPTS% "-Xnoclassgc" "-XX:MaxGCPauseMillis=50"
SET JAVA_OPTS=%JAVA_OPTS% "-XX:+HeapDumpOnOutOfMemoryError" "-Dsun.stdout.encoding=UTF-8" "-Dsun.stderr.encoding=UTF-8"

REM Option -Denable.parallel.write=false is used to enable parallel write.
REM The program will export multiple files concurrently based on sliced subtasks to improves the overall performance.
REM But there is no guarantee that the data will be evenly distributed among those dumped files.
SET PROGRAM_OPTS= "-Dpicocli.usage.width=180"

REM Option `enable.parallel.write` is used to enable parallel write.
REM OBDumper will export multiple files concurrently based on sliced subtasks to improves the overall performance.
REM But there is no guarantee that the data will be evenly distributed among those dumped files.
SET PROGRAM_OPTS=%PROGRAM_OPTS% "-Denable.parallel.write=false"

REM Table names must not contain the '.' character to prevent ambiguity in filenames during import
REM Note:	This check aims to prevent ambiguity when use OBLoader to import from dumped files;
REM a table name containing '.' would make it impossible to extract the real table name from the filename upon import, thus failing to correctly map to the database table
REM e.g. table: `test.1` may yield 3 possible output depends on dump options, which is, `test.1.csv`, `test.1.0.csv` or `test.1.1.0.csv`.
REM If you intend to do so as the potential risk is well acknowledged, feel free to skip this check.
SET PROGRAM_OPTS=%PROGRAM_OPTS% "-Dskip.tableName.check=false"

REM This variable decides what buffer to use when dump data to cloud object storage, including amazon s3, aliyun oss and any other s3-compat service.
REM The options are:
REM - disk: Use local disk as buffer. Capacity is limited to available disk space. Use cli arg `--tmp-path` to specify the buffer path.
REM - bytebuffer: Use an in-memory bytebuffer. Fast and require no capacity limit for disk spaces, but will cost heap memory significantly.
SET PROGRAM_OPTS=%PROGRAM_OPTS% "-Dupload.buffer.type=disk"
REM This variable decides the buffer size of one block in bytes.
SET PROGRAM_OPTS=%PROGRAM_OPTS% "-Dupload.buffer.size=67108864"
REM This variable decides how many blocks can exist at the same time of a single writer(table-based or subtask-based, depends on the value of `enable.parallel.write`).
SET PROGRAM_OPTS=%PROGRAM_OPTS% "-Dupload.active.blocks=2"

REM Configures the s3 client to disable chunked encoding for all requests.
REM Note: Enabling this option has performance implications since the checksum for the payload will have to be pre-calculated before sending the data.
REM Using this option is recommended only if your endpoint does not implement chunked uploading.
SET PROGRAM_OPTS=%PROGRAM_OPTS% "-Dupload.disable.chunked.encoding=false"

REM This variable decides whether to enable sql monitor log.
SET PROGRAM_OPTS=%PROGRAM_OPTS% "-DsqlMonitor.enabled=true"
REM This variable decides the threshold to report a slow sql. Unit: milliseconds.
SET PROGRAM_OPTS=%PROGRAM_OPTS% "-DsqlMonitor.slowSql.threshold=3000"

REM This variable determines whether to export the indexes included in the Oracle table definition.
SET PROGRAM_OPTS=%PROGRAM_OPTS% "-Denable.table.index=true"
REM This variable determines whether to export the comments included in the Oracle table definition.
SET PROGRAM_OPTS=%PROGRAM_OPTS% "-Denable.table.comment=true"
REM This variable determines whether to export the comments contained in the Oracle columns defined by the table.
SET PROGRAM_OPTS=%PROGRAM_OPTS% "-Denable.table.column.comment=true"

REM This parameter decides the size of data stored in memory before being upload to OSS.
REM Increasing this parameter will improve throughput by reducing the overall number of IOs, but will significantly increase jvm memory usage.
REM If this parameter is not specified or set to 0, it will be computed by pre-allocated jvm memory.
REM SET PROGRAM_OPTS=%PROGRAM_OPTS% "-Dwrite.memory.buffer=0"

SET PROGRAM_OPTS=%PROGRAM_OPTS% "-Dtool.base.dir=%PARENT_PATH%"
SET PROGRAM_OPTS=%PROGRAM_OPTS% "-Dobproxy.configurationFile=%PARENT_PATH%/conf/secure.crt"
SET PROGRAM_OPTS=%PROGRAM_OPTS% "-Dsession.configurationFile=%PARENT_PATH%/conf/session.config.json"
SET PROGRAM_OPTS=%PROGRAM_OPTS% "-Ddecrypt.configurationFile=%PARENT_PATH%/conf/decrypt.properties"
SET PROGRAM_OPTS=%PROGRAM_OPTS% "-Dlog4j.output=%PARENT_PATH%/logs" "-Dlog4j2.formatMsgNoLookups=true" "-Dlog4j.configurationFile=file:///%PARENT_PATH%/conf/log4j2.xml"
SET PROGRAM_OPTS=%PROGRAM_OPTS% "-Dhadoop.home.dir=%PARENT_PATH%/ext/windows/hadoop"

SET MAIN_CLASS=com.oceanbase.tools.loaddump.cmd.Obdumper

IF "%DEBUG_MODE%" == "1" (
    SET PROGRAM_OPTS=%PROGRAM_OPTS% "-Dlogback.configurationFile=%PARENT_PATH%/conf/jdbc-trace.xml"
    ECHO %JAVA_EXE% %JAVA_OPTS% %PROGRAM_OPTS% -classpath "%CLASSPATH%" %MAIN_CLASS% %*
)

%JAVA_EXE% %JAVA_OPTS% %PROGRAM_OPTS% -classpath "%CLASSPATH%" %MAIN_CLASS% %*

GOTO END
:END
ENDLOCAL
CMD /C