# ob-loader-dumper CHANGELOG

## 4.3.4.1 (2025-09-17)

### 新增功能

- 恢复了 --date-format 选项，用于导入过程中在 MySQL 模式下设置解析 date 以及 datetime 类型数据的日期格式；
- 恢复了 --default-date 选项，用于导入过程中在 MySQL 模式下按 --date-format 格式解析日期失败时返回的默认日期值；

### 缺陷修复

- 修复了导入多个表对象数据时可能引起 NPE 报错的问题；
- 修复了 --trail-delimiter 参数行为和 2.x 版本行为不兼容性问题；
- 修复了 MySQL 模式下导入导出数据使用控制文件时以大小写敏感模式匹配表列名的问题；
- 修复了控制文件中位于 constant 函数后的 position 函数截取数据错位的问题；
- 修复了导入字符串类型指定 --null-string '' 但仍以空字符串导入的问题；
- 修复了导入大量小表时可能导致内核抛出 "max open cursor exceed" 错误的问题；
- 修复了无定界符的的空字符串无法正确识别为 '' 而被识别为 NULL 的问题；
- 修复了导入表数据过程中宿主机 CPU 占用过高的问题；


## 4.3.4 (2025-07-31)

### 新增功能

- 提升了 ORC 文件的导入性能，平均提升超过 10 倍；
- 增加了对 OceanBase 4.3.5 的兼容和支持；
- 新增了 Oracle 模式下 xmltype 数据类型的支持;
- 新增了 MySQL 模式下 roaringbitmap，vector，sparsevector，array，map 数据类型的支持;
- 新增了 Oracle 模式下 User 以及 Role 对象定义和授权语句的导入导出;
- 新增了 MySQL 模式下 User 对象定义和授权语句的导入导出；
- 支持 true/false 数据和 tinyint 数据类型自动转化导入；
- 导入过程中增加内存水位控制，减少内存溢出概率；
- 导入过程中增加 GC 信息打印，帮助定位导入性能瓶颈；
- 增加启动参数 enable.partition.calculation，用于控制是否开启分区计算，默认开启；
- 增加启动参数 enable.contain.definer，用于控制存储过程和函数定义导出是否包含 definer 信息，默认开启；
- 增加启动参数 enable.table.index，用于控制 Oracle 模式下表定义导出是否包含索引信息，默认开启；
- 增加启动参数 enable.table.comment，用于控制 Oracle 模式下表定义导出是否包含表注释信息，默认开启；
- 增加启动参数 enable.table.column.comment，用于控制 Oracle 模式下表定义导出是否包含列注释信息，默认开启；

### 缺陷修复

- 修复了导入过程中 --max-tps 控制不准确的问题；
- 修复了导出过程中使用 exclude 指令排除主键或唯一键后报错 "The column type is null" 的问题；
- 修复了 Oracle 模式下只读实例导出对象时报错 "may not perform insert/delete/update operation inside a READ ONLY transaction" 的问题；
- 修复了 Oracle 模式下使用 mix 模式或 sql 模式导入时，无法正确解析 SQL 内容中带有反斜杠的案例，进而陷入死循环并最终内存溢出的问题；
- 修复了控制文件扩张列导致分区计算时发生 ArrayOutOfBoundException 的报错问题；
- 修复了导入过程中 bad 和 discard 记录有小概率不被记录在日志文件中的问题；
- 修复了不指定转义符的情况下，导入 CSV 文件过程中可能出现的逻辑切分位置计算错误而导致的导入失败问题；
- 修复了无任何对象需要导出情况下组件报错退出的问题；
- 修复了导入过程中可能出现大量 "Calculate leader of table failed, treat it as non-partition table." 报错刷屏的问题；
- 修复了导出到 OSS 且 OSS 不支持 multi-chunk encoding 情况下，导数工具显示导出成功但实际未有数据写入到 OSS 的问题；
- 修复了 --replace-object 参数对 type 对象无效的问题；
- 修复了导出以分号结束的 Type 对象后再导入失败，并报错 "Syntax Error" 的问题；
- 修复了 Oracle 模式下无法在小写用户名以及小写 Schema 场景下导入导出的问题；
- 修复了在导入导出时未指定 --table/--all 选项而导致报错 NPE 的问题；
- 修复了导入列数量不匹配时报错空异常的问题；
- 修复了无法指定文件名将数据导出至 OSS 文件的问题；
- 修复了导出序列时报错 "The next value is bigger than the max value" 的问题；
- 修复了 Oracle 模式下快照导出临时表时报错 "No valid replicas" 的问题；
- 修复了不能给导数组件分配超过 48GB 内存的问题；
- 修复了 --server 模式下导入失败但导数组件显示成功的问题；
- 修复了导出数据时，同一时刻导出负载集中在某一张表或某张表的某几个分区上的问题；

### 漏洞修复

- 升级 obkv-table-client 版本以解决 netty-handler-4.1.100.Final 组件关联的CVE-2025-24970 漏洞；
- 升级 Avro 版本以解决 avro-1.11.3 组件关联的 CVE-2024-47561 漏洞；

### 依赖库升级

- 将 oceanbase-client 组件的版本从 2.4.11 升级到 2.4.14；
- 将 ob-sql-parser 组件的版本从 1.4.0 升级到 1.4.2；
- 将 obkv-table-client 组件的版本从 1.2.13.1 升级到 1.2.13.2；
- 将 Avro 组件的版本从 1.11.3 升级到 1.11.4；


## 4.3.3.1 (2025-04-14)

### 新增功能

- 添加 --retain-schema 选项给导出的表、同义词添加 schema 信息;

### 缺陷修复

- 修复了表名以 recycle 开头的表未被导出的问题;
- 修复了导入不兼容 .par 后缀的文件导致未能识别获取的问题;
- 修复了 -P 端口重复报错 NPE 的问题;
- 修复了缺少必要参数报错 NPE 的问题;
- 修复了 --sys-password 密码错误时导出报错但结束状态为 exit 0 的问题;
- 修复了导出全库时未过滤临时表 __ctas_%_% 的问题;
- 修复了导入 double 数据报错 Truncated incorrect DOUBLE value 未生成 ob-loader-dumper.bad的问题;
- 修复了开启并行写和压缩时，导出的文件带有二级名称导致不能导入的问题;
- 修复了导入不生成 sql-monitor.log 文件的问题;
- 修复了导出 DDL 报 NPE 任务正常结束的问题;
- 修复了 oracle 服务端导入使用 load data 语句时出现无法指定单引号为转义符的问题;
- 修复了 oss 路径中存在特殊字符时导入 parquet 或 orc 文件时报错的问题;
- 修复了 win 平台上无法启动任务的问题;
- 修复了 win 平台上导出报错不能正常结束的问题;
- 修复了导出 DDL 报 NPE 任务正常结束的问题;
- 修复了使用 --no-sys 导出 3.x 集群表对象定义的虚拟列不正确的问题;
- 修复了无主键表导出报错 __pk_increment 数据类型为空的问题;
- 修复了 oracle 版本导出 BINARY 类型报错 NumberFormatException 的问题;
- 修复了导出的同义词DDL语句没有自动带上 schema 信息的问题;
- 修复了导出包含ORGANIZATION table option表的数据出现语法错误的问题;
- 修复了3.x版本数据库使用 --no-sys 导出表结构出现外键缺失的问题;
- 修复了导出报错 java.lang.NumberFormatException: For input string: "	-"" 的问题;
- 修复了识别大小写的中括号不生效的问题;


# ob-loader-dumper CHANGELOG

## 4.3.3 (2025-03-04)

### 新增功能

- 添加了 --truncate-table 清空所有表需二次确认行为修改;
- 添加了导出存储过程的定义包含 sql security 信息;
- 添加了导入导出过程执行的 SQL 增加版本注释;
- 添加了参数 -DdataSource.maxActive 用于控制连接池的最大活跃数;
- 添加了查询宏块范围和表元信息的功能和性能优化;
- 添加了任务分片和任务导出并行执行的结构修改;

### 缺陷修复

- 修复了导入 csv 格式的空数据文件使用 --auto-column-mapping 导入报错 NPE 的问题;
- 修复了单文件导出指定到文件名出现文件后缀重复的问题;
- 修复了 -f 指定明确的文件名后无法开启并行写的问题;
- 修复了 -f 指定为具体文件时应检测 block-size 是否为0的问题;
- 修复了 --auto-column-mapping 或 --source-type hive 影响 --replace-data 生效的问题;
- 修复了合并的日志存在无内容现象的问题;
- 修复了导入 csv 格式的文件报错 negative size 的问题;
- 修复了导入速率打印数据量更新的单位和刷新频率不匹配的问题;
- 修复了导出 orc 格式文件指定 --retain-empty-files 不生效的问题;
- 修复了使用 --truncate-table 选项导入忽视空表时出现计数不连续的问题;
- 修复了多表整库导出遇会话数管理溢出问题导致任务失败的问题;
- 修复了导入开启 debug 模式任务结束后无法退出的问题;
- 修复了 secure_file_priv 参数未配置的情况下服务端导入报错NPE的问题;


## 4.3.2.1 (2024-12-23)

### 缺陷修复

- 新增 --sequence-policy 选项，修复 Sequence 导出时 Start Value 不为 Sequence 的 currval 的问题；
- 修复导出时任务切片对 varbinary 类型的字段处理不当导致程序进入死循环的问题； 
- 修复导出 V4.3.1.1 指定--snapshot 选项，只导出一张表的问题； 
- 修复导出 Procedure  定义时未拼接 definer 的问题； 
- 修复导出联合主键的最右列值为空字符串的表报 NPE 的问题； 
- 修复导出 -Denable.parallel.write=true 文件合并功能与选项 --skip-header 耦合的问题； 
- 修复导出 -Denable.parallel.write=true 时 --block-size 不生效的问题； 
- 修复导入开启 --auto-column-mapping 空文件报错列不匹配的问题； 
- 修复服务端导入报错 Remote load only supports local file system 的问题； 
- 修复导入导出 V4.3.2 中指定 “--mem=1G” 的用法未生效的问题；