# ob-loader-dumper CHANGELOG

## 4.3.4.1 (2025-09-17)

### Features Added

- Restored the --date-format option to set the date format for parsing date and datetime type data during the import process in MySQL mode;
- Restored the --default-date option to provide the default date value returned when parsing fails with the --date-format format during the import process in MySQL mode;

### Bug Fixes

- Fixed the issue where importing data from multiple table objects may cause the NPE error;
- Fixed the incompatibility issue between the behavior of the --trail-delimiter parameter and version 2.x;
- Fixed the issue of table column names matching case sensitivity when importing and exporting data using control files in MySQL mode;
- Fixed the issue of data misalignment in the position function located after the constant function in the control file;
- Fixed the issue where the import string type specified --null-string option was '' but still imported as an empty string;
- Fixed the issue where importing a large number of small tables could cause the kernel to throw the 'max open cursor exceed' error;
- Fixed the issue where empty strings without delimiters cannot be correctly recognized as '' and are recognized as NULL;
- Fixed the issue of high CPU usage on the host during the process of importing table data;


## 4.3.4 (2025-07-31)

### Features Added

- Enhanced ORC file import performance, averaging over 10 times improvement;
- Added compatibility and support for OceanBase 4.3.5;
- Introduced support for the xmltype data type under Oracle mode;
- Introduced support for roaringbitmap, vector, sparsevector, array, and map data types under MySQL mode;
- Added import/export functionality for User and Role object definitions and permissions in Oracle mode;
- Added import/export functionality for User object definitions and permissions in MySQL mode;
- Supported automatic conversion of true/false and tinyint data types during import;
- Implemented memory water level control during import to reduce memory overflow risks;
- Added GC information logging during import to help identify performance bottlenecks;
- Introduced startup parameter enable.partition.calculation to control partition calculation, enabled by default;
- Introduced startup parameter enable.contain.definer to control inclusion of definer information in exported stored procedures and functions, enabled by default;
- Introduced startup parameter enable.table.index to control inclusion of index information in table exports under Oracle mode, enabled by default;
- Introduced startup parameter enable.table.comment to control inclusion of table comments in table exports under Oracle mode, enabled by default;
- Introduced startup parameter enable.table.column.comment to control inclusion of column comments in table exports under Oracle mode, enabled by default;

### Bug Fixes

- Fixed the issue of inaccurate control for --max-tps during import;
- Fixed the error "The column type is null" that occurred when excluding primary or unique keys using the exclude directive during export;
- Fixed the error "may not perform insert/delete/update operation inside a READ ONLY transaction" when exporting objects from a read-only instance in Oracle mode;
- Fixed the issue where import in mix or SQL mode in Oracle encountered a deadlock and memory overflow due to improperly parsed SQL content with backslashes;
- Fixed the ArrayOutOfBoundException error caused by resizing control file columns during partition calculation;
- Fixed the rare issue of bad and discard records not being logged during import;
- Fixed the import failure issue caused by incorrect logical split position calculation during CSV import when no escape character was specified;
- Fixed the error that caused the component to exit when no objects needed to be exported;
- Fixed the flooding of "Calculate leader of table failed, treat it as non-partition table." warnings during import;
- Fixed the issue where export to OSS indicated success but no data was written due to OSS not supporting multi-chunk encoding;
- Fixed the ineffectiveness of the --replace-object parameter for type objects;
- Fixed the import failure and "Syntax Error" when exporting type objects that ended with a semicolon;
- Fixed the import/export issue in Oracle mode with lowercase usernames and schemas;
- Fixed the NPE error that occurred when --table or --all options were not specified during import/export;
- Fixed the null exception error when the number of imported columns did not match;
- Fixed the issue of being unable to specify a filename for data export to OSS;
- Fixed the error "The next value is bigger than the max value" during sequence export;
- Fixed the "No valid replicas" error when exporting temporary tables for snapshots in Oracle mode;
- Fixed the limitation of not being able to allocate more than 48GB of memory to the export component;
- Fixed the issue where the import failed in --server mode but the export component showed success;
- Fixed the issue of export data being concentrated on a specific table or certain partitions of a table at the same time;

### Vulnerability Fixes

- Upgraded the obkv-table-client version to address the CVE-2025-24970 vulnerability associated with the netty-handler-4.1.100.Final component;
- Upgraded the Avro version to resolve the CVE-2024-47561 vulnerability associated with the avro-1.11.3 component;

### Dependency Upgrade

- Upgraded the oceanbase-client component version from 2.4.11 to 2.4.14;
- Upgraded the ob-sql-parser component version from 1.4.0 to 1.4.2;
- Upgraded the obkv-table-client component version from 1.2.13.1 to 1.2.13.2;
- Upgraded the Avro component version from 1.11.3 to 1.11.4;


## 4.3.3.1 (2025-04-14)

### Features Added

- Add the --retain-schema option to add schema information to exported tables and synonyms;

### Bug Fixes

- Fixed the problem that the table whose name starts with recycle was not exported;
- Fixed the problem that the import of incompatible .par suffix files caused the failure to identify and obtain;
- Fixed the problem of repeated NPE error for -P port;
- Fixed the problem of NPE error for missing necessary parameters;
- Fixed the problem that the export reported an error but the end status was exit 0 when the --sys-password password was incorrect;
- Fixed the problem that the temporary table __ctas_%_% was not filtered when exporting the entire database;
- Fixed the problem that the error Truncated incorrect DOUBLE value was reported when importing double data and ob-loader-dumper.bad was not generated;
- Fixed the problem that when parallel writing and compression were enabled, the exported file had a secondary name and could not be imported;
- Fixed the problem that the sql-monitor.log file was not generated when importing;
- Fixed the problem that the export DDL reported NPE and the task ended normally;
- Fixed the problem of using load data for Oracle server import - Fixed the problem that single quotes cannot be specified as escape characters when using statements;
- Fixed the problem that an error occurs when importing parquet or orc files when there are special characters in the oss path;
- Fixed the problem that tasks cannot be started on the win platform;
- Fixed the problem that the export error on the win platform cannot be completed normally;
- Fixed the problem that the export DDL task ends normally after reporting NPE;
- Fixed the problem that the virtual column defined when exporting 3.x cluster table objects using --no-sys is incorrect;
- Fixed the problem that the __pk_increment data type is empty when exporting tables without primary keys;
- Fixed the problem that the oracle version reports the error NumberFormatException when exporting BINARY type;
- Fixed the problem that the exported synonym DDL statement does not automatically carry schema information;
- Fixed the problem that the syntax error occurs when exporting data containing the ORGANIZATION table option table;
- Fixed the problem that the foreign key is missing when exporting the table structure using --no-sys for the 3.x version database;
- Fixed the problem of exporting error java.lang.NumberFormatException: For input string: " -";
- Fixed the problem of parentheses not taking effect in case recognition;


## 4.3.3 (2025-03-04)

### Features Added

- Added --truncate-table behavior modification that requires a second confirmation to clear all tables;
- Added definition of exported stored procedures including sql security information;
- Added SQL version comments for import and export process execution;
- Added parameter -DdataSource.maxActive to control the maximum number of active connections in the connection pool;
- Added functions and performance optimization for querying macro block range and table meta information;
- Added structural modification for task slicing and parallel execution of task exports;

### Bug Fixes

- Fixed the NPE error when using --auto-column-mapping to import empty data files in csv format;
- Fixed the duplicate file suffix when specifying the file name for single file export;
- Fixed the problem that parallel writing cannot be enabled after specifying a clear file name with -f;
- Fixed the problem that block-size should be checked to see if it is 0 when -f is specified as a specific file;
- Fixed the problem that --auto-column-mapping or --source-type hive affects the effectiveness of --replace-data;
- Fixed the problem that the merged log has no content;
- Fixed the issue of negative size error when importing csv format files;行
- Fixed the problem that the unit of the import rate print data volume update does not match the refresh frequency;
- Fixed the problem that retain-empty-files is not effective when exporting orc format files;
- Fixed the problem of count discontinuity when using the --truncate-table option to import ignoring empty tables;
- Fixed the problem that the task fails when exporting multiple tables and the entire database due to session number management overflow;
- Fixed the problem of debugging enabled when importing;
- Fixed the issue of being unable to exit after the mode task is completed;
- Fixed the issue of NPE error when the server imports when the secure_file_priv parameter is not configured;


## 4.3.2.1 (2024-12-23)

### Bug Fixes

- Added the --sequence-policy option to fix the problem that the Start Value is not the currval of the Sequence when exporting Sequence;
- Fixed the problem that the task slice improperly handles the varbinary type field during export, causing the program to enter an infinite loop;
- Fixed the problem that only one table is exported when specifying the --snapshot option when exporting V4.3.1.1;
- Fixed the problem that definer is not spliced when exporting Procedure definition;
- Fixed the problem that NPE is reported when exporting a table with an empty string value in the rightmost column of the joint primary key;
- Fixed the problem that the file merging function of exporting -Denable.parallel.write=true is coupled with the option --skip-header;
- Fixed the problem that --block-size does not take effect when exporting -Denable.parallel.write=true;
- Fixed the problem that the empty file error column mismatch is reported when importing with --auto-column-mapping turned on;
- Fixed the problem that the server import error Remote load only supports local file system;
- Fixed the issue that the usage of "--mem=1G" specified in import and export V4.3.2 did not take effect;